local copper_bars={}
local screenWidth,screenHeight=1920,1080
copper_bars.bars={}
copper_bars.numberOfBars=25
copper_bars.barHeight=screenHeight/copper_bars.numberOfBars
copper_bars.colorCycleSpeed=60
copper_bars.barWaveAmplitude=20
copper_bars.barWaveFrequency=2
copper_bars.active=false
copper_bars.time=0
copper_bars.currentAlpha=0
copper_bars.targetAlpha=0.64
copper_bars.fadeDuration=1
copper_bars.fadeTimer=0
copper_bars.isFadingIn=false
local function hsvToRgb(h,s,v)
local c=v*s
local x=c*(1-math.abs((h/60)%2-1))
local m=v-c
local r,g,b
if h<60 then
r,g,b=c,x,0
elseif h<120 then
r,g,b=x,c,0
elseif h<180 then
r,g,b=0,c,x
elseif h<240 then
r,g,b=0,x,c
elseif h<300 then
r,g,b=x,0,c
else
r,g,b=c,0,x
end
return r+m,g+m,b+m
end
function copper_bars.load()
math.randomseed(os.time())
for i=1,copper_bars.numberOfBars do
table.insert(copper_bars.bars,{y=(i-1)*copper_bars.barHeight,phase=math.random()*2*math.pi,currentY=(i-1)*copper_bars.barHeight,color={1,1,1,1}})
end end
function copper_bars.update(dt)
if copper_bars.active then
if not copper_bars.isFadingIn and copper_bars.currentAlpha<copper_bars.targetAlpha then
copper_bars.isFadingIn=true
end
if copper_bars.isFadingIn then
copper_bars.fadeTimer=copper_bars.fadeTimer+dt
copper_bars.currentAlpha=math.min(copper_bars.fadeTimer/copper_bars.fadeDuration*copper_bars.targetAlpha,copper_bars.targetAlpha)
if copper_bars.currentAlpha>=copper_bars.targetAlpha then
copper_bars.currentAlpha=copper_bars.targetAlpha
copper_bars.isFadingIn=false
end end
copper_bars.time=copper_bars.time+dt
for i,bar in ipairs(copper_bars.bars) do
local offset=copper_bars.barWaveAmplitude*math.sin(copper_bars.barWaveFrequency*copper_bars.time+bar.phase)
bar.currentY=bar.y+offset
local hue=(copper_bars.time*copper_bars.colorCycleSpeed+(i*(360/copper_bars.numberOfBars)))%360
local r,g,b=hsvToRgb(hue,1,1)
bar.color={r,g,b,copper_bars.targetAlpha}
end end end
function copper_bars.draw()
if copper_bars.active and copper_bars.currentAlpha>0 then
for i,bar in ipairs(copper_bars.bars) do
local displayColor={bar.color[1],bar.color[2],bar.color[3],bar.color[4]*(copper_bars.currentAlpha/copper_bars.targetAlpha)}
love.graphics.setColor(displayColor)
love.graphics.rectangle("fill",0,bar.currentY,screenWidth,copper_bars.barHeight+1)
end
love.graphics.setColor(1,1,1,1)
end end
return copper_bars
